require 'rake/clean'
require 'fileutils'
require 'rubygems'

SOLUTION = "solution.sln"
msbuild_exe = File.join(File.join(ENV['windir'].dup, 'Microsoft.NET', 'Framework',  'v3.5'), 'msbuild.exe')

CLEAN.include('artifacts','**/bin','**/obj')

artifacts_dir = File.join('artifacts')
output_dir = File.join('artifacts','output')

task :default => [:run]

task :init => :clean do
	mkdir artifacts_dir
	mkdir output_dir
end

task :compile => :init do
	sh "#{msbuild_exe} #{SOLUTION} /p:Configuration=Release;OutDir=#{File.expand_path(output_dir)}/ /t:Rebuild /nologo /m /v:q"
end

task :run => :compile do
	sh "#{output_dir}/tuio.exe"
end

task :run_client do
	sh "#{output_dir}/client.exe"
end
