using System;
using System.IO;
using log4net;
using log4net.Config;

namespace utility.logging
{
    public class Log4NetLogFactory : LogFactory
    {
        public Log4NetLogFactory()
        {
            XmlConfigurator.Configure(path_to_config_file());
        }

        public Logger create_for(Type type_to_create_logger_for)
        {
            return new Log4NetLogger(LogManager.GetLogger(type_to_create_logger_for));
        }

        FileInfo path_to_config_file()
        {
            return new FileInfo(Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "log4net.config.xml"));
        }
    }
}