using System;
using System.Collections.Specialized;
using System.Configuration;

namespace utility
{
    public class Settings
    {
        NameValueCollection settings;

        public Settings() : this(ConfigurationManager.AppSettings) {}

        public Settings(NameValueCollection settings)
        {
            this.settings = settings;
        }

        public T named<T>(string key)
        {
            var value = settings[key];
            if (string.IsNullOrEmpty(value)) return default(T);
            return (T) Convert.ChangeType(value, typeof (T));
        }
    }
}