using System;
using System.Collections.Generic;
using System.Linq;

namespace utility
{
    static public class Iterating
    {
        static public void each<T>(this IEnumerable<T> items, Action<T> action)
        {
            foreach (var item in items ?? Enumerable.Empty<T>()) action(item);
        }

        static public void each_with_index<T>(this IEnumerable<T> items, Action<T, int> action)
        {
            for (var i = 0; i < items.Count(); i++) action(items.ElementAt(i), i);
        }
    }
}