using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace tuio
{
    public class Xml : Serializable
    {
        StringBuilder builder = new StringBuilder();
        Encoding encoding;

        public Xml() : this(new ASCIIEncoding()) {}

        public Xml(Encoding encoding)
        {
            this.encoding = encoding;
        }

        public void add(string xml, params object[] arguments)
        {
            builder.AppendFormat(xml, arguments);
            builder.AppendLine();
        }

        public byte[] to_bytes()
        {
            return null_terminating_bytes().ToArray();
        }

        IEnumerable<byte> null_terminating_bytes()
        {
            foreach (var encoded_byte in encoding.GetBytes(builder.ToString()))
                yield return encoded_byte;
            yield return 0;
        }

        public override string ToString()
        {
            return builder.ToString();
        }
    }
}