using System;
using System.Collections.Generic;
using utility;
using utility.logging;

namespace tuio
{
    static public class TouchTrigger
    {
        static readonly List<Observer<Touch>> observers = new List<Observer<Touch>>();

        static public void fire(Touch touch)
        {
            observers.each(observer => do_safely(() =>
            {
                observer(touch);
            }));
        }

        static void do_safely(Action action)
        {
            try
            {
                action();
            }
            catch (Exception e)
            {
                action.log().error(e);
            }
        }

        static public void register(Observer<Touch> observer)
        {
            observers.Add(observer);
        }
    }
}