using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using utility;
using utility.logging;

namespace tuio
{
    public class TcpConnection : Connection, IDisposable
    {
        Socket listen_socket;
        List<Socket> connected_sockets = new List<Socket>();
        object mutex = new object();
        public string ip { get; private set; }
        public int port { get; private set; }

        TcpConnection(Socket listen_socket)
        {
            this.listen_socket = listen_socket;
            listen_socket.Listen(4);
            listen_socket.BeginAccept(x => client_connected(x), null);
        }

        static public TcpConnection open(string ip, int port)
        {
            var socket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
            socket.Bind(new IPEndPoint(IPAddress.Parse(ip), port));
            return new TcpConnection(socket) { ip = ip, port=port};
        }

        public void send(Serializable message)
        {
            var to_send = message.to_bytes();

            mutex.with_lock(() =>
            {
                connected_sockets.ToList().each(x =>
                {
                    try
                    {
                        x.Send(to_send);
                    }
                    catch (SocketException e)
                    {
                        e.log();
                        connected_sockets.Remove(x);
                    }
                });
            });
        }

        public void Dispose()
        {
            if (null == listen_socket) return;
            if (listen_socket.Connected) listen_socket.Disconnect(false);
            listen_socket = null;
        }

        void client_connected(IAsyncResult async)
        {
            mutex.with_lock(() =>
            {
                "client connected".log();
                connected_sockets.Add(listen_socket.EndAccept(async));
            });
            listen_socket.BeginAccept(x => client_connected(x), null);
        }
    }
}