using System;
using System.Collections.Generic;

namespace tuio
{
    public class TUIOProtocol : Protocol
    {
        public TUIOProtocol(double screen_width, double screen_height)
        {
            this.screen_width = screen_width;
            this.screen_height = screen_height;
        }

        public void record(Touch touch)
        {
            touches[touch.id] = touch;
        }

        public void publish_to(Connection connection)
        {
            connection.send(build_for(connection));
        }

        Serializable build_for(Connection connection)
        {
            var xml = new Xml();
            xml.add("<OSCPACKET ADDRESS='{0}' PORT='{1}' TIME='{2}'>", connection.ip, connection.port, create_time_stamp());
            foreach (var touch in touches.Values)
            {
                touch.append_header(xml, screen_width, screen_height);
            }
            xml.add("<MESSAGE NAME='/tuio/2Dcur'>");
            xml.add("<ARGUMENT TYPE='s' VALUE='alive' />");
            foreach (var touch in touches.Values)
            {
                touch.append_footer(xml);
            }
            xml.add("</MESSAGE>");
            xml.add("<MESSAGE NAME='/tuio/2Dcur'>");
            xml.add("<ARGUMENT TYPE='s' VALUE='fseq'/>");
            xml.add("<ARGUMENT TYPE='i' VALUE='{0}'/>", sequence.next());
            xml.add("</MESSAGE>");
            xml.add("</OSCPACKET>");
            return xml;
        }

        double create_time_stamp()
        {
            return DateTime.Now.Subtract(reference_time).TotalMilliseconds/1000000000;
        }

        Sequence sequence = new Sequence();
        IDictionary<long, Touch> touches = new Dictionary<long, Touch>();
        double screen_width;
        double screen_height;
        DateTime reference_time = new DateTime(1900, 1, 1);
    }
}