﻿using System;
using System.Runtime.InteropServices;
using System.Windows;
using System.Windows.Input;
using System.Windows.Interop;
using SBSDKComWrapperLib;

namespace tuio
{
    public partial class Shell : SubjectOf<Opacity>
    {
        Opacity current_opacity;

        [DllImport("user32.dll")]
        static public extern int RegisterWindowMessageA([MarshalAs(UnmanagedType.LPStr)] string lpString);

        int SBSDKMessageID = RegisterWindowMessageA("SBSDK_NEW_MESSAGE");
        ISBSDKBaseClass2 Sbsdk;

        public Shell()
        {
            InitializeComponent();
            current_opacity = new Dim();
            KeyDown += (o, e) => pressed(e.Key);

            Loaded += (o, e) =>
            {
                Sbsdk = new SBSDKBaseClass2();
                ((_ISBSDKBaseClass2Events_Event) Sbsdk).OnXYDown += (x, y, z, pointer_id) => down(x, y, pointer_id);
                ((_ISBSDKBaseClass2Events_Event) Sbsdk).OnXYMove += (x, y, z, pointer_id) => down(x, y, pointer_id);
                ((_ISBSDKBaseClass2Events_Event) Sbsdk).OnXYUp += (x, y, z, pointer_id) => up(x, y, pointer_id);

                var handle = new WindowInteropHelper(this).Handle;
                var int_handle = handle.ToInt32();
                Sbsdk.SBSDKAttachWithMsgWnd(int_handle, false, int_handle);
                Sbsdk.SBSDKSetSendMouseEvents(int_handle, _SBCSDK_MOUSE_EVENT_FLAG.SBCME_NEVER, -1);
                //Sbsdk.SBSDKSetMultiPointerMode(Sbsdk.SBSDKGetCurrentBoard(), true);
                HwndSource.FromHwnd(handle).AddHook(new_message);
            };
        }

        void pressed(Key key)
        {
            if (key == Key.K) current_opacity.apply_next_opacity_to(this);
            if (key == Key.Escape) Application.Current.Shutdown();
        }

        public void change_to(Opacity next_state)
        {
            current_opacity = next_state;
        }

        IntPtr new_message(IntPtr hWnd, int Msg, IntPtr wParam, IntPtr lParam, ref bool Handled)
        {
            if (Msg == SBSDKMessageID && Sbsdk != null) Sbsdk.SBSDKProcessData();
            return IntPtr.Zero;
        }

        static void up(double x, double y, int pointer_id)
        {
            TouchTrigger.fire(new Up(pointer_id));
        }

        static void down(double x, double y, int pointer_id)
        {
            TouchTrigger.fire(new Down(pointer_id, x, y));
        }
    }
}