namespace tuio
{
    public class Sequence
    {
        ulong current;
        readonly object mutex = new object();

        public Sequence() : this(ulong.MinValue) {}

        public Sequence(ulong beginning)
        {
            current = beginning;
        }

        public ulong next()
        {
            return mutex.with_lock(() =>
            {
                current++;
                if (current.Equals(0)) current++;
                return current;
            });
        }
    }
}