namespace tuio
{
    public class ReleaseClick : MouseGesture
    {
        readonly SubjectOf<MouseGesture> window;

        public ReleaseClick(SubjectOf<MouseGesture> window)
        {
            this.window = window;
        }

        public void move(double x, double y, int pointer_id)
        {
            up(x, y, pointer_id);
        }

        public void up(double x, double y, int pointer_id)
        {
            TouchTrigger.fire(new Up(pointer_id));
        }

        public void down(double x, double y, int pointer_id)
        {
            var gesture = new ClickDown(window);
            window.change_to(gesture);
            gesture.down(x, y, pointer_id);
        }
    }
}