using System;

namespace tuio
{
    static public class Locking
    {
        static public void with_lock<T>(this T mutex, Action action) where T : class
        {
            lock (mutex) action();
        }

        static public K with_lock<T, K>(this T mutex, Func<K> action) where T : class
        {
            lock (mutex) return action();
        }
    }
}