namespace tuio
{
    public class Down : Touch
    {
        public Down(long id, double x, double y)
        {
            this.id = id;
            this.x = x;
            this.y = y;
        }

        public long id { get; private set; }

        public void append_header(Xml xml, double screen_width, double screen_height)
        {
            xml.add("<MESSAGE NAME='/tuio/2Dcur\'>");
            xml.add("<ARGUMENT TYPE='s' VALUE='set' />");
            xml.add("<ARGUMENT TYPE='i' VALUE='{0}' />", id);
            xml.add("<ARGUMENT TYPE='f' VALUE='{0}' />", plot_x(screen_width));
            xml.add("<ARGUMENT TYPE='f' VALUE='{0}' />", plot_y(screen_height));
            xml.add("<ARGUMENT TYPE='f' VALUE='0.0000000' />");
            xml.add("<ARGUMENT TYPE='f' VALUE='0.0000000' />");
            xml.add("<ARGUMENT TYPE='f' VALUE='0.0000000' />");
            xml.add("</MESSAGE>");
        }

        public void append_footer(Xml xml)
        {
            xml.add("<ARGUMENT TYPE='i' VALUE='{0}' />", id);
        }

        double plot_x(double screen_width)
        {
            return x/screen_width;
        }

        double plot_y(double screen_height)
        {
            return y/screen_height;
        }

        double x;
        double y;
    }
}