using System;
using System.Collections.Generic;
using System.Windows.Threading;
using utility;

namespace tuio
{
    public class CommandProcessor : Command
    {
        readonly int frames_per_second;
        List<Command> commands = new List<Command>();

        public CommandProcessor(int frames_per_second)
        {
            this.frames_per_second = frames_per_second;
        }

        public void add(Command command)
        {
            commands.Add(command);
        }

        public void run()
        {
            var timer = new DispatcherTimer
            {
                Interval = TimeSpan.FromSeconds(1.0/frames_per_second)
            };
            timer.Tick += (o, e) => commands.each(x => x.run());
            timer.Start();
        }
    }
}
