namespace tuio
{
    public class ClickDown : MouseGesture
    {
        SubjectOf<MouseGesture> window;

        public ClickDown(SubjectOf<MouseGesture> window)
        {
            this.window = window;
        }

        public void move(double x, double y, int pointer_id)
        {
            down(x, y, pointer_id);
        }

        public void up(double x, double y, int pointer_id)
        {
            var gesture = new ReleaseClick(window);
            gesture.up(x, y, pointer_id);
            window.change_to(gesture);
        }

        public void down(double x, double y, int pointer_id)
        {
            TouchTrigger.fire(new Down(pointer_id, x, y));
        }
    }
}