using System;
using System.Configuration;
using System.Windows;
using utility;
using utility.logging;

namespace tuio
{
    static public class Bootstrapper
    {
        [STAThread]
        static public void Main()
        {
            "started server".log();
            try
            {
                var settings = new Settings();

                var protocol = new TUIOProtocol(SystemParameters.PrimaryScreenWidth, SystemParameters.PrimaryScreenHeight);
                TouchTrigger.register(protocol.record);

                var connection = TcpConnection.open(settings.named<string>("ip"), settings.named<int>("port"));
                var publish_touch = new PublishTouch(connection, protocol);
                var active_object = new CommandProcessor(settings.named<int>("frames_per_second"));
                active_object.add(publish_touch);

                var window = new Shell();
                window.Loaded += (o, e) => active_object.run();

                var application = new Application {ShutdownMode = ShutdownMode.OnMainWindowClose};
                application.Exit += (o, e) =>
                {
                    "shutting down".log();
                    connection.Dispose();
                };
                application.DispatcherUnhandledException += (o, e) => handle(e.Exception);
                application.Run(window);
            }
            catch (Exception e)
            {
                handle(e);
            }
        }

        static void handle(Exception e)
        {
            e.log();
            new ErrorWindow {DataContext = e}.ShowDialog();
        }
    }
}
