﻿using System;
using System.Collections.Generic;
using System.Net;
using System.Net.Sockets;
using System.Text;
using utility;
using utility.logging;

namespace client
{
    class Program
    {
        static void Main()
        {
            var client = new TcpClient();
            try
            {
                var settings = new Settings();
                client.Connect(IPAddress.Parse(settings.named<string>("ip")), settings.named<int>("port"));

                var encoding = new ASCIIEncoding();
                var buffer = new byte[1024];
                while (true)
                {
                    client.GetStream().Read(buffer, 0, buffer.Length);
                    var message = encoding.GetString(buffer);
                    Console.Clear();
                    Console.Out.WriteLine(message);
                    clear(buffer);
                }
            }
            catch (Exception e)
            {
                e.log();
            }
            finally
            {
                client.Close();
            }
        }

        static void clear(IList<byte> buffer)
        {
            for (var i = 0; i < buffer.Count; i++) buffer[i] = 0;
        }
    }
}