using project.domain.accounting;

namespace unit.domain.accounting
{
    public class SummaryAccountSpecs
    {
        public abstract class concern : runner<SummaryAccount>
        {
            protected override SummaryAccount create_sut()
            {
                return SummaryAccount.New(Currency.CAD);
            }
        }

        [Concern(typeof (SummaryAccount))]
        public class when_retrieving_the_balance_from_a_summary_account : concern
        {
            context c = () =>
            {
                cash =  DetailAccount.New(Currency.CAD);
                credit = DetailAccount.New(Currency.CAD);

                cash.deposit(50, Currency.CAD);
                credit.deposit(50, Currency.CAD);
            };

            because b = () =>
            {
                sut.add(cash);
                sut.add(credit);
                result = sut.balance();
            };

            it should_sum_the_balance_for_each_detail_account = () =>
            {
                result.should_be_equal_to(new Quantity(100.00, Currency.CAD));
            };

            static Quantity result;
            static DetailAccount cash;
            static DetailAccount credit;
        }
    }
}