using project.domain.accounting;

namespace unit.domain.accounting
{
    public class CurrencySpecs
    {
        public abstract class concern : runner<Currency>
        {
            public override void cleanup()
            {
                SimpleUnitOfMeasure.provide_rate((x, y) => ConversionRatio.Default);
            }
        }

        [Concern(typeof (Currency))]
        public class when_converting_one_USD_dollar_to_CAD : concern
        {
            context c = () =>
            {
                SimpleUnitOfMeasure.provide_rate((x, y) => new ConversionRatio(1.05690034));
            };

            it should_return_the_correct_amount = () =>
            {
                sut.convert(1, Currency.CAD).should_be_equal_to(1.05690034);
            };

            protected override Currency create_sut()
            {
                return Currency.USD;
            }
        }

        [Concern(typeof (Currency))]
        public class when_converting_one_CAD_dollar_to_USD : concern
        {
            context c = () =>
            {
                SimpleUnitOfMeasure.provide_rate((x, y) => new ConversionRatio(0.95057));
            };

            it should_return_the_correct_amount = () =>
            {
                sut.convert(1.05690034d, Currency.USD).should_be_equal_to(1.0046577561938002d);
            };

            protected override Currency create_sut()
            {
                return Currency.CAD;
            }
        }
    }
}