using project.domain.accounting;

namespace unit.domain.accounting
{
    public class BOEDSpecs
    {
        public abstract class concern : runner<BOED>
        {
            protected override BOED create_sut()
            {
                return new BOED();
            }
            public override void cleanup()
            {
                SimpleUnitOfMeasure.provide_rate((x, y) => ConversionRatio.Default);
            }
        }

        [Concern(typeof (BOED))]
        public class when_converting_one_barrel_of_oil_equivalent_to_one_mcf : concern
        {
            context c = () =>
            {
                SimpleUnitOfMeasure.provide_rate((x, y) =>
                {
                    return new ConversionRatio(6);
                });
            };

            because b = () =>
            {
                result = sut.convert(1, new MCF());
            };

            it should_return_the_corrent_value = () =>
            {
                result.should_be_equal_to(6);
            };

            static double result;
        }
    }
}