using System;
using project.domain;

namespace unit.domain
{
    public class DateSpecs
    {
        public abstract class concern : run {}

        [Concern(typeof (Date))]
        public class when_checking_if_a_date_is_before_another : concern
        {
            context c = () =>
            {
                today = DateTime.Now;
                tomorrow = today.plus_days(1);
            };

            it should_return_true_when_it_is = () =>
            {
                today.is_before(tomorrow).should_be_true();
            };

            it should_return_false_when_it_is_not = () =>
            {
                tomorrow.is_before(today).should_be_false();
            };

            static Date today;
            static Date tomorrow;
        }

        [Concern(typeof (Date))]
        public class when_checking_if_a_date_is_after_another : concern
        {
            context c = () =>
            {
                today = DateTime.Now;
                tomorrow = today.plus_days(1);
            };

            it should_return_true_when_it_is = () =>
            {
                tomorrow.is_after(today).should_be_true();
            };

            it should_return_false_when_it_is_not = () =>
            {
                today.is_after(tomorrow).should_be_false();
            };

            static Date today;
            static Date tomorrow;
        }
    }
}