using System;
using NUnit.Framework;

namespace unit
{
    static public class AssertionExtensions
    {
        static public void should_not_be_null<T>(this T item)
        {
            Assert.IsNotNull(item);
        }

        static public void should_be_an_instance_of<T>(this object actual)
        {
            Assert.IsInstanceOf<T>(actual);
        }

        static public void should_be_equal_to<T>(this T actual, T expected)
        {
            Assert.AreEqual(expected, actual);
        }

        static public void should_not_be_equal_to<T>(this T actual, T expected)
        {
            Assert.AreNotEqual(expected, actual);
        }

        static public void should_be_true(this bool actual)
        {
            Assert.IsTrue(actual);
        }

        static public void should_be_false(this bool actual)
        {
            Assert.IsFalse(actual);
        }

        static public void should_have_thrown<Exception>(this Action action) where Exception : System.Exception
        {
            try
            {
                action();
                Assert.Fail("Did not throw.");
            }
            catch (Exception e)
            {
                if (!e.GetType().Equals(typeof (Exception)))
                {
                    Assert.Fail("Threw the wrong exception");
                }
            }
        }
    }
}