require 'rake/clean'
require 'fileutils'

CLEAN.include('artifacts','**/bin','**/obj')

artifacts_dir = File.join('artifacts')
deploy_dir = File.join(artifacts_dir,'deploy')
reports_dir = File.join(artifacts_dir,'reports')

task :default => [:test]

task :init => :clean do
	mkdir artifacts_dir
	mkdir deploy_dir
	mkdir reports_dir
end

task :compile => :init do
	framework_dir = File.join(ENV['windir'].dup, 'Microsoft.NET', 'Framework', 'v3.5')
	msbuild_file = File.join(framework_dir, 'msbuild.exe')
	sh "#{msbuild_file} solution.sln /p:Configuration=Release;OutDir=#{File.expand_path(deploy_dir)}/ /t:Rebuild /nologo /m /v:q"
end

task :test => :compile do 
	file = File.expand_path( "unit.dll",deploy_dir)
	report = File.expand_path('unit.dll-results',reports_dir)

	sh "thirdparty/nunit/nunit-console.exe #{file} /out:#{report} /nologo"
end

task :dump do
	puts "hello ruby universe."
end
