using project.domain.algorithms;

namespace unit.domain.algorithms
{
    public class BinaryTreeSpecs
    {
        public abstract class concern : runner<BinaryTree<int>>
        {
            protected override BinaryTree<int> create_sut()
            {
                return new BinaryTree<int>(head);
            }

            static protected int head;
        }

        [Concern(typeof (BinaryTree<int>))]
        public class when_adding_an_item_greater_than_the_current_node : concern
        {
            context c = () =>
            {
                head = 2;
            };

            because b = () =>
            {
                sut.add(new_item);
            };

            it should_add_the_item_to_the_right_side_of_the_tree = () =>
            {
                sut.right().should_be_equal_to(new_item);
            };

            static int new_item = 3;
        }

        [Concern(typeof (BinaryTree<int>))]
        public class when_adding_an_item_less_than_the_current_node : concern
        {
            context c = () =>
            {
                head = 2;
            };

            because b = () =>
            {
                sut.add(new_item);
            };

            it should_add_the_item_to_the_right_side_of_the_tree = () =>
            {
                sut.left().should_be_equal_to(new_item);
            };

            static int new_item = 1;
        }

        [Concern(typeof (BinaryTree<int>))]
        public class when_searching_for_an_item_in_a_binary_tree : concern
        {
            context c = () =>
            {
                head = 5;
            };

            because b = () =>
            {
                for (var i = 0; i < 10; i++) sut.add(i);
            };

            it should_return_the_item_when_found = () =>
            {
                sut.find(3).should_be_equal_to(3);
            };
        }
    }
}