using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;

namespace unit
{
    static public class Reflecting
    {
        static public void class_hierarchy(this Type target, Action<Type> action)
        {
            action(target);
            var base_class = target.BaseType;
            if (null != base_class) base_class.class_hierarchy(action);
        }

        static public IEnumerable<FieldInfo> collect_fields_of_type<T>(this IReflect target)
        {
            return target
                .GetFields(BindingFlags.NonPublic | BindingFlags.Instance)
                .Where(x => x.FieldType.Equals(typeof (T)));
        }

        static public void invoke_delegate_on(this FieldInfo field, object target)
        {
            field.GetValue(target).downcast_to<Delegate>().DynamicInvoke();
        }
    }
}