using System;

namespace project.domain.algorithms
{
    public class BinaryTree<T> where T : IComparable<T>
    {
        readonly T item;
        BinaryTree<T> right_tree;
        BinaryTree<T> left_tree;

        public BinaryTree(T item)
        {
            this.item = item;
        }

        public void add(T new_item)
        {
            var comparison = new_item.CompareTo(item);

            if (comparison == 0) return;

            if (comparison > 0)
            {
                if (right_tree == null)
                    right_tree = new BinaryTree<T>(new_item);
                else
                    right_tree.add(new_item);
                return;
            }

            if (comparison < 0)
            {
                if (left_tree == null)
                    left_tree = new BinaryTree<T>(new_item);
                else
                    left_tree.add(new_item);
                return;
            }
        }

        public T right()
        {
            return right_tree.item;
        }

        public T left()
        {
            return left_tree.item;
        }

        public T find(T item_to_find)
        {
            var comparison = item_to_find.CompareTo(item);
            if (comparison == 0) return item;

            if (comparison > 0)
            {
                return right_tree.find(item_to_find);
            }

            if (comparison < 0)
            {
                return left_tree.find(item_to_find);
            }
            throw new NotImplementedException();
        }
    }
}