using System;

namespace project.domain.accounting
{
    public delegate ConversionRatio ExchangeRate(Currency unitCurrency, Currency referenceCurrency);

    public class Currency : UnitOfMeasure
    {
        static public readonly Currency USD = new Currency("USD");
        static public readonly Currency CAD = new Currency("CAD");

        Currency(string pneumonic)
        {
            this.pneumonic = pneumonic;
        }

        public double convert(double amount, UnitOfMeasure other)
        {
            if (other.Equals(this)) return amount;
            if (other is Currency) return convert(amount, (Currency) other);

            throw new NotImplementedException();
        }

        public string pretty_print(double amount)
        {
            return "{0:C} {1}".format(amount, this);
        }

        double convert(double amount, Currency other)
        {
            return exchange_rate(this, other).applied_to(amount);
        }

        static ExchangeRate exchange_rate = (x, y) => ConversionRatio.Default;

        static public void provide_exchange_rates(ExchangeRate exchange_rate_provider)
        {
            exchange_rate = exchange_rate_provider;
        }

        public bool Equals(Currency other)
        {
            if (ReferenceEquals(null, other)) return false;
            if (ReferenceEquals(this, other)) return true;
            return Equals(other.pneumonic, pneumonic);
        }

        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj)) return false;
            if (ReferenceEquals(this, obj)) return true;
            if (obj.GetType() != typeof (Currency)) return false;
            return Equals((Currency) obj);
        }

        public override int GetHashCode()
        {
            return (pneumonic != null ? pneumonic.GetHashCode() : 0);
        }

        static public bool operator ==(Currency left, Currency right)
        {
            return Equals(left, right);
        }

        static public bool operator !=(Currency left, Currency right)
        {
            return !Equals(left, right);
        }

        public override string ToString()
        {
            return pneumonic;
        }

        string pneumonic;
    }
}