using System;
using System.IO;
using System.Threading;

namespace utility.logging
{
    public class TextLogger : Logger
    {
        readonly TextWriter writer;

        public TextLogger(TextWriter writer)
        {
            this.writer = writer;
        }

        public void debug(string formatted_string, params object[] arguments)
        {
            writer.WriteLine("[{0}] - {1}", Thread.CurrentThread.ManagedThreadId, string.Format(formatted_string, arguments));
        }

        public void error(Exception e)
        {
            writer.WriteLine("{0}", e);
        }
    }
}