using System;

namespace utility.logging
{
    static public class LoggingExtensions
    {
        static public void log(this string message, params object[] arguments)
        {
            Log.For(message).debug(message, arguments);
        }

        static public Logger log<T>(this T item_to_log)
        {
            return Log.For(item_to_log);
        }

        static public void log(this Exception error_to_log)
        {
            Log.For(error_to_log).error(error_to_log);
        }
    }
}