using System;
using log4net;

namespace utility.logging
{
    public class Log4NetLogger : Logger
    {
        readonly ILog log;

        public Log4NetLogger(ILog log)
        {
            this.log = log;
        }

        public void debug(string formatted_string, params object[] arguments)
        {
            log.DebugFormat(formatted_string, arguments);
        }

        public void error(Exception e)
        {
            log.Error(e.ToString());
        }
    }
}