using System;

namespace utility.logging
{
    static public class Log
    {
        static readonly LogFactory log_factory = new Log4NetLogFactory();

        static public Logger For<T>(T item)
        {
            return For(typeof (T));
        }

        static public Logger For(Type type_to_create_a_logger_for)
        {
            try
            {
                return log_factory.create_for(type_to_create_a_logger_for);
            }
            catch
            {
                return new TextLogger(Console.Out);
            }
        }
    }
}