using System.Collections.Generic;
using System.Linq;

namespace utility.extensions
{
    static public class Mapping
    {
        static public IEnumerable<Output> MapAllUsing<Input, Output>(this IEnumerable<Input> items, IMapper mapper)
        {
            foreach (var input in items ?? Enumerable.Empty<Input>()) yield return mapper.MapFrom<Input, Output>(input);
        }
    }
}