﻿using System;
using System.DirectoryServices;
using it.service.domain;
using utility.extensions;
using utility.logging;

namespace it.service.infrastructure
{
    public class ActiveDirectoryGateway : IActiveDirectoryGateway
    {
        public Account CreateAccountFor(Guid employeeId, string first_name, string last_name)
        {
            var id = CreateAccountInADLDS(first_name, last_name);
            //CreateAccountOnLocalMachine(first_name, last_name);
            //DisplayMembersOf("administrators");
            return new Account(firstName: first_name, lastName: last_name, activeDirectoryId: id, employeeId: employeeId);
        }

        //void DisplayMembersOf(string group)
        //{
        //    var machine = new DirectoryEntry("WinNT://" + Environment.MachineName + ",Computer");
        //    var members = machine.Children.Find(group, "group").Invoke("members", null);
        //    foreach (var member in (IEnumerable) members)
        //    {
        //        var entry = new DirectoryEntry(member);
        //        entry.Name.log();
        //    }
        //    //machine.Children.Find(group, "group").Children.Add()
        //}

        //void CreateAccountOnLocalMachine(string firstname, string lastname)
        //{
        //    using (var machine = new DirectoryEntry("WinNT://" + Environment.MachineName))
        //    {
        //        using (var user = machine.Children.Add(username_for(firstname,lastname), "user"))
        //        {
        //            user.Invoke("SetPassword", new object[] {"password"});
        //            user.CommitChanges();
        //            "The new users Id is: {0}".log(user.Guid);
        //            user.Close();
        //        }
        //        machine.Close();
        //    }
        //}

        Guid CreateAccountInADLDS(string firstname, string lastname)
        {
            Guid userId;
            using (var machine = new DirectoryEntry("LDAP://localhost:50000/CN=Demo,DC=mokhan,DC=local"))
            {
                LogAll(machine);

                using (var user = machine.Children.Add("CN={0}".format(username_for(firstname, lastname)), "user"))
                {
                    user.Properties["givenName"].Value = "{0} {1}".format(firstname, lastname);
                    user.Properties["sn"].Value = lastname;
                    //user.Properties["samAccountName"].Value = username_for(firstname,lastname);
                    //user.Properties["userAccountControl"].Value = (int)user.Properties["userAccountControl"].Value | 0x80000;
                    //user.Properties["userAccountControl"].Value = (int)user.Properties["userAccountControl"].Value & ~0x2;

                    //user.Invoke("SetPassword", new object[] { "password" });
                    user.CommitChanges();
                    "the users new id is: {0}".log(user.Guid);
                    user.Close();
                    userId = user.Guid;
                }

                machine.CommitChanges();
                LogAll(machine);
                machine.Close();
            }
            return userId;
        }

        void LogAll(DirectoryEntry entry)
        {
            foreach (DirectoryEntry e in entry.Children) e.Name.log();
        }

        string username_for(string firstName, string lastName)
        {
            return "{0}{1}".format(firstName.first_letter(), lastName);
        }
    }
}