using common.messages;
using easyhr.messages;
using it.service.infrastructure;
using it.service.orm.repositories;

namespace it.service.handlers
{
    public class HandlesNewEmployeeHired : Handles<NewEmployeeHired>
    {
        IActiveDirectoryGateway gateway;
        IAccountRepository accounts;

        public HandlesNewEmployeeHired(IActiveDirectoryGateway gateway, IAccountRepository accounts)
        {
            this.gateway = gateway;
            this.accounts = accounts;
        }

        public override void Handle(NewEmployeeHired message)
        {
            accounts.Add(gateway.CreateAccountFor(message.Id, message.FirstName, message.LastName));
        }
    }
}