﻿using it.messages;
using it.service.domain;
using it.service.orm.repositories;
using NServiceBus;
using utility;
using utility.extensions;
using utility.logging;

namespace it.service.handlers
{
    public class GetAllUsernamesMessageHandler : IHandleMessages<GetAllUserNamesQuery>
    {
        IBus bus;
        IUserRepository users;
        IMapper mapper;

        public GetAllUsernamesMessageHandler(IBus bus, IUserRepository users, IMapper mapper)
        {
            this.bus = bus;
            this.mapper = mapper;
            this.users = users;
        }

        public void Handle(GetAllUserNamesQuery message)
        {
            "Received query for all usernames.".log();
            users.FindAll().MapAllUsing<User, UserCredentials>(mapper).Each(x =>
            {
                bus.Reply(x);
            });
        }
    }
}