﻿using Castle.MicroKernel.Registration;
using Castle.Windsor;
using it.service.infrastructure;
using utility;

namespace it.service.bootstrap
{
    public class RegisterComponentsInTo : ICommand
    {
        readonly WindsorContainer container;

        public RegisterComponentsInTo(WindsorContainer container)
        {
            this.container = container;
        }

        public void Run()
        {
            container.Register(Component.For<IActiveDirectoryGateway>().ImplementedBy<ActiveDirectoryGateway>().LifeStyle.Transient);
        }
    }
}