﻿using Castle.MicroKernel.Registration;
using Castle.Windsor;
using it.service.orm.repositories;
using it.service.orm.repositories.stubs;
using utility;

namespace it.service.bootstrap
{
    public class ConfigureORM : ICommand
    {
        WindsorContainer container;

        public ConfigureORM(WindsorContainer container)
        {
            this.container = container;
        }

        public void Run()
        {
            container.Register(Component.For<IUserRepository>().ImplementedBy<StubUserRepository>().LifeStyle.Singleton);
            container.Register(Component.For<IAccountRepository>().ImplementedBy<StubAccountRepository>().LifeStyle.Singleton);
        }
    }
}