﻿using System;
using System.Collections.Generic;
using System.Linq;
using AutoMapper;
using Castle.MicroKernel.Registration;
using Castle.Windsor;
using it.messages;
using it.service.domain;
using utility;

namespace it.service.bootstrap
{
    public class ConfigureAutoMapper : ICommand
    {
        readonly WindsorContainer container;

        public ConfigureAutoMapper(WindsorContainer container)
        {
            this.container = container;
        }

        public void Run()
        {
            ConfigureMappings();
            container.Register(Component.For<IMapper>().ImplementedBy<DefaultMapper>());
        }

        void ConfigureMappings()
        {
            CreateMap<User, UserCredentials>(x =>
            {
                return new UserCredentials
                       {
                           Username = "username",
                           Password = "password"
                       };
            });
        }

        void CreateMap<Input, Output>(Func<Input, Output> factory)
        {
            Mapper.CreateMap<Input, Output>().ConvertUsing(factory);
        }

        static IEnumerable<Output> MapAll<Input, Output>(IEnumerable<Input> items)
        {
            return (items ?? Enumerable.Empty<Input>()).Select(item => Mapper.Map<Input, Output>(item)).ToList();
        }
    }
}