﻿using Castle.Windsor;
using it.service.bootstrap;
using NServiceBus;
using utility.extensions;

namespace it.service
{
    public class ConfigureThisEndPoint : IConfigureThisEndpoint, AsA_Publisher, IWantCustomLogging
    {
        public void Init() {}
    }

    public class Initialize : IWantCustomInitialization
    {
        public void Init()
        {
            var container = new WindsorContainer();
            Configure.Instance.RijndaelEncryptionService();
            Configure
                .With()
                .Log4Net()
                .CastleWindsorBuilder(container)
                .XmlSerializer()
                .RijndaelEncryptionService()
                .MsmqTransport().IsTransactional(true).PurgeOnStartup(true)
                .MsmqSubscriptionStorage()
                .UnicastBus().ImpersonateSender(false).LoadMessageHandlers()
                .CreateBus()
                .Start()
                ;

            new ConfigureAutoMapper(container)
                .Then(new ConfigureORM(container))
                .Then(new RegisterComponentsInTo(container))
                .Run();
        }
    }
}