﻿using easyhr.messages;
using easyhr.web.cache;
using easyhr.web.viewdata;
using NServiceBus;

namespace easyhr.web.handlers
{
    public class HandlesNewEmployeeHired : IHandleMessages<NewEmployeeHired>
    {
        ICache<EmployeeViewData> employees;

        public HandlesNewEmployeeHired(ICache<EmployeeViewData> employees)
        {
            this.employees = employees;
        }

        public void Handle(NewEmployeeHired message)
        {
            employees.Add(new EmployeeViewData
                          {
                              Id = message.Id,
                              FirstName = message.FirstName,
                              LastName = message.LastName,
                              HasChangesPending = false
                          });
        }
    }
}