using easyhr.messages;
using easyhr.web.cache;
using easyhr.web.viewdata;
using NServiceBus;

namespace easyhr.web.handlers
{
    public class HandlesEmployeeAddressChanged : IHandleMessages<EmployeeAddressChanged>
    {
        ICache<EmployeeViewData> cache;

        public HandlesEmployeeAddressChanged(ICache<EmployeeViewData> cache)
        {
            this.cache = cache;
        }

        public void Handle(EmployeeAddressChanged message)
        {
            var employee = cache.ByKey(message.Id);
            employee.Address = message.Address;
            employee.City = message.City;
            employee.Province = message.Province;
            employee.PostalCode = message.PostalCode;
            employee.HasChangesPending = false;
        }
    }
}