using NServiceBus;
using utility.logging;

namespace easyhr.web.handlers
{
    public class HandleAll : IHandleMessages<IMessage>
    {
        IBus bus;

        public HandleAll(IBus bus)
        {
            this.bus = bus;
        }

        public void Handle(IMessage message)
        {
            "received message {0}".log(message);
            "message context {0}{1}{2}".log(bus.CurrentMessageContext.Id, bus.CurrentMessageContext.Headers, bus.CurrentMessageContext.ReturnAddress);
        }
    }
}