﻿using System;
using System.Collections.Generic;
using System.Linq;
using utility;

namespace easyhr.web.cache
{
    public class WebCache<Data> : ICache<Data> where Data : IIdentifiable
    {
        IDictionary<Guid, Data> items;

        public WebCache()
        {
            items = new Dictionary<Guid, Data>();
        }

        public IEnumerable<Data> All()
        {
            return items.Values.AsEnumerable();
        }

        public void Add(Data item)
        {
            items[item.Id] = item;
        }

        public Data ByKey(Guid id)
        {
            return items.ContainsKey(id) ? items[id] : default(Data);
        }
    }
}