﻿using System;
using System.Web.Mvc;
using easyhr.messages.commands;
using easyhr.web.cache;
using easyhr.web.viewdata;
using NServiceBus;

namespace easyhr.web.ui.Controllers
{
    public class EmployeesController : SmartController
    {
        IBus bus;
        ICache<EmployeeViewData> employees;

        public EmployeesController(IBus bus, ICache<EmployeeViewData> employees)
        {
            this.bus = bus;
            this.employees = employees;
        }

        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult new_hire(HireNewEmployee command)
        {
            bus.Send(command);
            return RedirectToAction("all");
        }

        public ActionResult all()
        {
            return View(employees.All());
        }

        public ActionResult view(Guid id)
        {
            return View(employees.ByKey(id));
        }

        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult change_address(ChangeEmployeeAddress command)
        {
            bus.Send(command);
            employees.ByKey(command.Id).HasChangesPending = true;
            return RedirectToAction("all");
        }
    }
}