using System;
using System.Collections.Generic;
using easyhr.service.domain;
using NHibernate;

namespace easyhr.service.orm.repositories.stubs
{
    public class StubEmployeeRepository : IEmployeeRepository
    {
        IDictionary<Guid, Employee> employees = new Dictionary<Guid, Employee>();
        ISessionFactory factory;

        public StubEmployeeRepository(ISessionFactory factory)
        {
            this.factory = factory;
        }

        public Employee IdentifiedBy(Guid id)
        {
            //ISession current_session = factory.GetCurrentSession();
            //return employees.ContainsKey(id) ? employees[id] : default(Employee);
            using (var session = factory.OpenSession())
            {
                return session.Load<Employee>(id);
            }
        }

        public void Add(Employee employee)
        {
            //employee.Id = Guid.NewGuid();
            //employees[employee.Id] = employee;
            using (var session = factory.OpenSession())
            {
                session.SaveOrUpdate(employee);
            }
        }
    }
}