﻿using System;
using System.Data;
using easyhr.service.domain;
using NHibernate;
using NHibernate.SqlTypes;
using NHibernate.UserTypes;
using utility.extensions;

namespace easyhr.service.orm.mappings
{
    public class PostalCodeUserType : IUserType
    {
        public bool Equals(object x, object y)
        {
            return x != null && x.Equals(y);
        }

        public int GetHashCode(object x)
        {
            return x.GetHashCode();
        }

        public object NullSafeGet(IDataReader rs, string[] names, object owner)
        {
            return new PostalCode(NHibernateUtil.String.NullSafeGet(rs, names).As<string>());
        }

        public void NullSafeSet(IDbCommand cmd, object value, int index)
        {
            NHibernateUtil.String.NullSafeSet(cmd, value.As<PostalCode>().Code, index);
        }

        public object DeepCopy(object value)
        {
            return new PostalCode(value.As<PostalCode>().Code);
        }

        public object Replace(object original, object target, object owner)
        {
            return original;
        }

        public object Assemble(object cached, object owner)
        {
            return cached;
        }

        public object Disassemble(object value)
        {
            return value;
        }

        public SqlType[] SqlTypes
        {
            get { return new[] {NHibernateUtil.String.SqlType}; }
        }

        public Type ReturnedType
        {
            get { return typeof (PostalCode); }
        }

        public bool IsMutable
        {
            get { return false; }
        }
    }
}