﻿using System.Threading;
using common.messages;
using easyhr.messages;
using NServiceBus;
using utility.extensions;

namespace easyhr.service.handlers
{
    public class RequestDataMessageHandler : Handles<RequestDataMessage>
    {
        IBus bus;

        public RequestDataMessageHandler(IBus bus)
        {
            this.bus = bus;
        }

        public override void Handle(RequestDataMessage message)
        {
            "Received request {0}.".format(message.DataId);
            "String received: {0}.".format(message.String);
            "Secret Question received: {0}.".format(message.SecretQuestion.Value);
            "Header 'Test' = {0}.".format(message.GetHeader("Test"));

            var principal = Thread.CurrentPrincipal;
            var response = bus.CreateInstance<DataResponseMessage>(m =>
            {
                m.DataId = message.DataId;
                m.String = message.String;
                m.SecretAnswer = message.SecretQuestion;
            });

            response.CopyHeaderFromRequest("Test");
            response.SetHeader("1", "1");
            response.SetHeader("2", "2");

            bus.Reply(response); //You can try experimenting with sending multiple replies
        }
    }
}