using common.messages;
using easyhr.messages;
using easyhr.messages.commands;
using easyhr.service.domain;
using easyhr.service.orm.repositories;
using NServiceBus;

namespace easyhr.service.handlers
{
    public class HandlesHireNewEmployee : Handles<HireNewEmployee>
    {
        IBus bus;
        IEmployeeRepository employees;

        public HandlesHireNewEmployee(IBus bus, IEmployeeRepository employees)
        {
            this.bus = bus;
            this.employees = employees;
        }

        public override void Handle(HireNewEmployee message)
        {
            var employee = new Employee(first_name: message.first_name, last_name: message.last_name);
            employees.Add(employee);
            bus.Publish<NewEmployeeHired>(x =>
            {
                x.Id = employee.Id;
                x.FirstName = message.first_name;
                x.LastName = message.last_name;
            });
        }
    }
}