using common.messages;
using easyhr.messages;
using easyhr.messages.commands;
using easyhr.service.orm.repositories;
using NServiceBus;

namespace easyhr.service.handlers
{
    public class HandlesChangeEmployeeAddress : Handles<ChangeEmployeeAddress>
    {
        IBus bus;
        IEmployeeRepository employees;

        public HandlesChangeEmployeeAddress(IBus bus, IEmployeeRepository employees)
        {
            this.bus = bus;
            this.employees = employees;
        }

        public override void Handle(ChangeEmployeeAddress message)
        {
            employees
                .IdentifiedBy(message.Id)
                .ChangeAddressTo(message.address, message.city, message.province, message.postal_code);

            bus.Publish<EmployeeAddressChanged>(x =>
            {
                x.Id = message.Id;
                x.Address = message.address;
                x.City = message.city;
                x.Province = message.province;
                x.PostalCode = message.postal_code;
            });
        }
    }
}