﻿using System;
using utility;

namespace easyhr.service.domain
{
    public abstract class Entity : IEquatable<Entity>, IIdentifiable
    {
        protected Entity()
        {
            Id = default(Guid);
        }

        public virtual Guid Id { get; set; }

        public virtual bool Equals(Entity other)
        {
            if (ReferenceEquals(null, other)) return false;
            if (ReferenceEquals(this, other)) return true;
            if (Id == default(Guid) || other.Id == default(Guid)) return false;
            return other.Id == Id;
        }

        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj)) return false;
            if (ReferenceEquals(this, obj)) return true;
            if (!(obj is Entity)) return false;
            return Equals((Entity) obj);
        }

        public override int GetHashCode()
        {
            return Id.GetHashCode();
        }

        static public bool operator ==(Entity left, Entity right)
        {
            return Equals(left, right);
        }

        static public bool operator !=(Entity left, Entity right)
        {
            return !Equals(left, right);
        }
    }
}